/*
 * Decompiled with CFR 0.152.
 */
package org.kauss.app;

import com.pingtel.util.PingerConfigFileParser;
import com.pingtel.xpressa.Application;
import com.pingtel.xpressa.awt.PActionItem;
import com.pingtel.xpressa.awt.PBottomButtonBar;
import com.pingtel.xpressa.awt.PCommandBar;
import com.pingtel.xpressa.awt.PContainer;
import com.pingtel.xpressa.awt.PDefaultListModel;
import com.pingtel.xpressa.awt.PLabel;
import com.pingtel.xpressa.awt.PList;
import com.pingtel.xpressa.awt.PListModel;
import com.pingtel.xpressa.awt.PTextField;
import com.pingtel.xpressa.awt.event.PActionEvent;
import com.pingtel.xpressa.awt.event.PActionListener;
import com.pingtel.xpressa.awt.form.PAbstractForm;
import com.pingtel.xpressa.awt.form.PApplicationForm;
import com.pingtel.xpressa.awt.form.SimpleTextForm;
import com.pingtel.xpressa.sys.util.PingerInfo;
import java.awt.Component;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;
import org.kauss.app.IMapConfigForm;
import org.kauss.gui.MailBox;

public class IMapClientForm
extends PApplicationForm {
    static final String version = "V 1.1";
    private static final String protocol = "imap";
    private static final String mbox = "INBOX";
    private static final String mbox2 = "Inbox";
    private static final String SERVER = "IMAP_SERVER";
    private static final String USER = "IMAP_USER";
    private static final String PASSWD = "IMAP_PASWD";
    private static final String DEBUG = "IMAP_DEBUG";
    private static final String REMOVE = "IMAP_REMOVE";
    private String mailServer = "not.set";
    private String mailUser = "nobody";
    private String mailPas = "secret";
    private boolean mailDebug = false;
    private boolean removeFile = false;
    private URLName url = null;
    private Session session = null;
    private Store store = null;
    private Folder[] folderList;
    private Folder folder = null;
    private Folder selectedFolder = null;
    private Message selectedMessage = null;
    private Message[] messageList;
    private boolean configOK = false;
    private PList f_listCallLog;
    private PDefaultListModel f_listModel;
    private PCommandBar f_commandBar;
    private folderCommandDispatcher f_commandDispatcher;
    private PList emailList;
    private PDefaultListModel emailListModel;
    private emailCommandDispatcher emailCommandDispatcher = null;
    private PList mailList;
    private PDefaultListModel listModel;
    private PCommandBar m_commandBar;
    private PList configList = null;
    private PDefaultListModel configModel = null;
    private PTextField mailServerField = null;
    private CommandDispatcher commandDispatcher;

    private String getAddress(Address a) {
        String pers = null;
        if (a instanceof InternetAddress && (pers = ((InternetAddress)a).getPersonal()) != null) {
            return pers + " <" + ((InternetAddress)a).getAddress() + ">";
        }
        return a.toString();
    }

    public void readProfile() {
        String s1 = PingerInfo.getInstance().getFlashFileSystemLocation();
        String s2 = s1 + File.separator + "kaussMail";
        Hashtable hashtable = new Hashtable();
        if (this.mailDebug) {
            System.out.println("==> readProfile");
        }
        try {
            hashtable = PingerConfigFileParser.getConfigFile((String)s2);
        }
        catch (IOException _ex) {
            block23: {
                if (this.mailDebug) {
                    System.out.println("Error getting " + s2 + "Create new one");
                }
                hashtable.put(SERVER, this.mailServer);
                hashtable.put(USER, this.mailUser);
                hashtable.put(PASSWD, this.mailPas);
                if (this.mailDebug) {
                    hashtable.put(DEBUG, "true");
                } else {
                    hashtable.put(DEBUG, "false");
                }
                if (this.removeFile) {
                    return;
                }
                try {
                    PingerConfigFileParser.setConfigFile((String)s2, (Hashtable)hashtable);
                }
                catch (Exception ee) {
                    if (!this.mailDebug) break block23;
                    System.out.println("Error Create " + s2 + " " + ee.toString());
                }
            }
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String s3 = (String)enumeration.nextElement();
            String s4 = (String)hashtable.get(s3);
            if (s3.equals(SERVER)) {
                this.mailServer = s4;
            } else if (s3.equals(USER)) {
                this.mailUser = s4;
            } else if (s3.equals(PASSWD)) {
                this.mailPas = s4;
            } else if (s3.equals(DEBUG)) {
                this.mailDebug = !s4.equals("false");
            } else if (s3.equals(REMOVE)) {
                this.removeFile = !s4.equals("false");
            }
            if (!this.mailDebug) continue;
            System.out.println(s3 + " == " + s4);
        }
        if (this.mailDebug) {
            System.out.println("IMAP_SERVER=" + this.mailServer);
        }
        if (this.mailDebug) {
            System.out.println("IMAP_USER=" + this.mailUser);
        }
        if (this.mailDebug) {
            System.out.println("IMAP_PASWD=" + this.mailPas);
        }
        if (this.mailDebug) {
            System.out.println("IMAP_REMOVE=" + this.removeFile);
        }
    }

    public void config() {
        if (this.mailDebug) {
            System.out.println("==> config");
        }
        this.configOK = true;
        IMapConfigForm configForm = new IMapConfigForm(this.getApplication(), this.mailDebug);
        configForm.showModal();
        if (this.mailDebug) {
            System.out.println("<== config");
        }
        this.readProfile();
        this.configModel.removeAllElements();
        this.configModel.addElement((Object)"IMAP Server :");
        this.configModel.addElement((Object)this.mailServer);
        this.configModel.addElement((Object)"Mail User :");
        this.configModel.addElement((Object)this.mailUser);
    }

    public IMapClientForm(Application application) {
        super(application, "Call Log Mail");
        if (this.mailDebug) {
            System.out.println("==> IMapClientForm V 1.1");
        }
        this.commandDispatcher = new CommandDispatcher();
        this.setTitle("IMAP Mail V 1.1");
        this.setHelpText("call_log", "call_log_title");
        this.readProfile();
        this.initFolderMenue();
        this.initMenubar();
        this.configWindow();
    }

    protected void displayErrorForm(String title, String s) {
        if (this.mailDebug) {
            System.out.println("==> displayErrorForm");
        }
        SimpleTextForm simpletextform = new SimpleTextForm(this.getApplication(), title);
        simpletextform.setText(s);
        simpletextform.showModal();
    }

    private void initFolderMenue() {
        if (this.mailDebug) {
            System.out.println("==> initFolderMenue");
        }
        this.mailList = new PList();
        this.listModel = new PDefaultListModel();
        this.mailList.setListModel((PListModel)this.listModel);
        this.mailList.addActionListener((PActionListener)this.commandDispatcher);
        this.configList = new PList();
        this.configModel = new PDefaultListModel();
        this.configList.setListModel((PListModel)this.configModel);
        this.configModel.removeAllElements();
        this.configModel.addElement((Object)"IMAP Server :");
        this.configModel.addElement((Object)this.mailServer);
        this.configModel.addElement((Object)"Mail User :");
        this.configModel.addElement((Object)this.mailUser);
    }

    private void initMailMenue() {
        if (this.mailDebug) {
            System.out.println("==> initMailMenue");
        }
        this.f_listCallLog = new PList();
        this.f_listModel = new PDefaultListModel();
        this.f_listCallLog.setBounds(0, 2, 157, 104);
        this.f_listCallLog.setListModel((PListModel)this.f_listModel);
        this.f_listCallLog.addActionListener((PActionListener)this.f_commandDispatcher);
    }

    private void initEMailMenue() {
        if (this.mailDebug) {
            System.out.println("==> initEMailMenue");
        }
        this.emailList = new PList();
        this.emailListModel = new PDefaultListModel();
        this.emailList.setListModel((PListModel)this.emailListModel);
        this.emailList.addActionListener((PActionListener)this.commandDispatcher);
    }

    private void initFolderCommandBar() {
        if (this.mailDebug) {
            System.out.println("==> initFolderCommandBar");
        }
        this.f_commandBar = new PCommandBar();
        this.f_commandBar.addActionListener((PActionListener)this.f_commandDispatcher);
        PActionItem pactionitem = new PActionItem(new PLabel(this.getImage("imgFilterIcon")), "TOP", null, "top");
        this.f_commandBar.addButton(pactionitem);
        PActionItem pactionitem1 = new PActionItem(new PLabel(this.getImage("imgSortIcon")), "LAST", null, "last");
        this.f_commandBar.addButton(pactionitem1);
    }

    private void initMailMenubar() {
        if (this.mailDebug) {
            System.out.println("==> initMailMenubar");
        }
        PBottomButtonBar pbottombuttonbar = this.getBottomButtonBar();
        PActionItem pactionitem = new PActionItem(new PLabel("Back"), "BACK", (PActionListener)this.commandDispatcher, "back");
        pbottombuttonbar.setItem(0, pactionitem);
    }

    private void folderMenubar() {
        if (this.mailDebug) {
            System.out.println("==> folderMenubar");
        }
        PBottomButtonBar pbottombuttonbar = this.getBottomButtonBar();
        PActionItem pactionitem = new PActionItem(new PLabel("Main"), "MAIN", (PActionListener)this.commandDispatcher, "main");
        pbottombuttonbar.setItem(0, pactionitem);
        pbottombuttonbar.clearItem(2);
    }

    private void initEMailMenubar() {
        if (this.mailDebug) {
            System.out.println("==> initEMailMenubar");
        }
        PBottomButtonBar pbottombuttonbar = this.getBottomButtonBar();
        PActionItem pactionitem = new PActionItem(new PLabel("Back"), "BACK", (PActionListener)this.commandDispatcher, "back");
        pbottombuttonbar.setItem(0, pactionitem);
    }

    private void initMenubar() {
        if (this.mailDebug) {
            System.out.println("==> initMenubar");
        }
        PBottomButtonBar pbottombuttonbar = this.getBottomButtonBar();
        PActionItem pactionitem = new PActionItem(new PLabel("Config"), "config", (PActionListener)this.commandDispatcher, "config");
        pbottombuttonbar.setItem(0, pactionitem);
        PActionItem pactionitem1 = new PActionItem(new PLabel("Exit"), "call_log/exit", (PActionListener)this.commandDispatcher, "exit");
        pbottombuttonbar.setItem(1, pactionitem1);
        PActionItem pactionitem2 = new PActionItem(new PLabel("Read Mail"), "readMail", (PActionListener)this.commandDispatcher, "readMail");
        pbottombuttonbar.setItem(2, pactionitem2);
    }

    private void folderListLayout() {
        if (this.mailDebug) {
            System.out.println("==> folderListLayout");
        }
        try {
            PContainer pcontainer = new PContainer();
            pcontainer.setLayout(null);
            this.mailList.setBounds(0, 2, 157, 104);
            pcontainer.add((Component)this.mailList);
            this.addToDisplayPanel((Component)pcontainer, new Insets(0, 0, 0, 0));
        }
        catch (Exception e) {
            System.out.println("folderListLayout : error " + e.toString());
            e.printStackTrace();
        }
    }

    private void configWindow() {
        if (this.mailDebug) {
            System.out.println("==> configWindow");
        }
        try {
            PContainer pcontainer = new PContainer();
            pcontainer.setLayout(null);
            this.configList.setBounds(0, 2, 157, 104);
            pcontainer.add((Component)this.configList);
            this.addToDisplayPanel((Component)pcontainer, new Insets(0, 0, 0, 0));
        }
        catch (Exception e) {
            System.out.println("configWindow : error " + e.toString());
            e.printStackTrace();
        }
    }

    private void mailListLayout() {
        if (this.mailDebug) {
            System.out.println("==> mailListLayout");
        }
        try {
            PContainer pcontainer = new PContainer();
            pcontainer.setLayout(null);
            pcontainer.add((Component)this.f_listCallLog);
            this.addToDisplayPanel((Component)pcontainer, new Insets(0, 0, 0, 0));
        }
        catch (Exception e) {
            System.out.println("layoutComponents : error " + e.toString());
            e.printStackTrace();
        }
        if (this.mailDebug) {
            System.out.println("<== mailListLayout");
        }
    }

    public void onCancel() {
        if (this.mailDebug) {
            System.out.println("==> onCancel");
        }
        if (this.removeFile) {
            String s1 = PingerInfo.getInstance().getFlashFileSystemLocation();
            String s2 = s1 + File.separator + "kaussMail";
            File file = new File(s2);
            if (this.mailDebug) {
                System.out.println("removeConfig");
            }
            try {
                file.delete();
            }
            catch (Exception e) {
                System.out.println("Error : delete file " + s2 + ", : " + e.toString());
            }
        }
        super.closeForm(1);
    }

    public void readFolderEntrys() {
        int selectedFolderNumber = this.mailList.getSelectedIndex();
        String folderName = (String)this.mailList.getSelectedElement();
        if (this.mailDebug) {
            System.out.println("==> readFolderEntrys : selectedFolderNumber = " + selectedFolderNumber + " Name =" + folderName);
        }
        this.setTitle((String)this.mailList.getSelectedElement());
        this.f_commandDispatcher = new folderCommandDispatcher();
        this.initMailMenue();
        this.initMailMenubar();
        this.selectedFolder = this.folderList[selectedFolderNumber];
        try {
            if (!this.selectedFolder.isOpen()) {
                this.selectedFolder.open(2);
            }
            int msgCount = this.selectedFolder.getMessageCount();
            if (this.mailDebug) {
                System.out.println("msgCount = " + msgCount);
            }
            for (int i = 1; i <= msgCount; ++i) {
                this.selectedMessage = this.selectedFolder.getMessage(i);
                if (this.selectedMessage.isSet(Flags.Flag.DELETED) && !this.selectedFolder.getName().equals("Trash")) continue;
                if (this.selectedMessage.getSubject() == null) {
                    if (this.mailDebug) {
                        System.out.println(i + " No Subject");
                    }
                    this.f_listModel.addElement((Object)"No Subject");
                    continue;
                }
                if (this.mailDebug) {
                    System.out.println(i + " " + this.selectedMessage.getSubject());
                    if (!this.selectedMessage.isSet(Flags.Flag.SEEN)) {
                        System.out.println("    UnRead");
                    }
                }
                this.f_listModel.addElement((Object)this.selectedMessage.getSubject());
            }
        }
        catch (Exception e) {
            System.out.println("Error read sub " + e.toString());
            e.printStackTrace();
        }
        this.mailListLayout();
    }

    public void readMailEntrys() {
        int selectedMailNumber = this.f_listCallLog.getSelectedIndex() + 1;
        if (this.mailDebug) {
            System.out.println("==> readMailEntrys selFolNr :" + selectedMailNumber);
        }
        try {
            int n = 0;
            Message[] message = this.selectedFolder.getMessages();
            this.selectedMessage = null;
            for (int i = 0; i < message.length; ++i) {
                if (!message[i].isSet(Flags.Flag.DELETED)) {
                    ++n;
                }
                if (n != selectedMailNumber) continue;
                this.selectedMessage = message[i];
                break;
            }
            if (this.selectedMessage == null) {
                if (this.mailDebug) {
                    System.out.println("no selected message");
                }
                return;
            }
            this.emailCommandDispatcher = new emailCommandDispatcher();
            MailBox m = new MailBox(this.getApplication(), this.emailCommandDispatcher, this.mailDebug);
            m.setButton(0, "Menu", "menu");
            m.setButton(2, "Close", "close");
            this.emailCommandDispatcher.setPAbstractForm(m);
            Address[] addr = this.selectedMessage.getFrom();
            m.setTitle(this.getAddress(addr[0]));
            Object obj = this.selectedMessage.getContent();
            if (obj instanceof String) {
                if (this.mailDebug) {
                    System.out.println((String)obj);
                }
                m.setMessage((String)obj);
            } else {
                m.setMessage("No text Message");
            }
            m.showModal();
        }
        catch (Exception e) {
            this.displayErrorForm("Display Message", " : " + e.getMessage());
            System.out.println("Error get message " + e.toString());
            e.printStackTrace();
        }
    }

    private void displayAllFolder() {
        if (this.mailDebug) {
            System.out.println("==> displayAllFolder");
        }
        this.listModel.removeAllElements();
        this.listModel.addElement((Object)"Connect to :");
        this.listModel.addElement((Object)this.mailServer);
        this.listModel.addElement((Object)"Please wait..");
        if (this.url == null) {
            this.url = new URLName(protocol, this.mailServer, -1, mbox, this.mailUser, this.mailPas);
        }
        try {
            int i;
            Properties props = System.getProperties();
            ((Hashtable)props).put("mail.smtp.host", this.mailServer);
            if (this.session == null || this.store == null) {
                this.session = Session.getDefaultInstance(props, null);
                this.session.setDebug(false);
                this.store = this.session.getStore(this.url);
                this.store.connect();
            }
            this.folder = this.store.getDefaultFolder();
            if (this.folder == null) {
                this.listModel.addElement((Object)"Error : No default folder");
                if (this.mailDebug) {
                    System.out.println("No default folder");
                }
                return;
            }
            this.listModel.removeAllElements();
            this.folderList = this.folder.list("%");
            if (this.mailDebug) {
                System.out.println(" folderList.length = " + this.folderList.length);
            }
            for (i = 1; i < this.folderList.length; ++i) {
                if (this.folderList[i].getName().equals(mbox) || this.folderList[i].getName().equals(mbox2)) {
                    this.folder = this.folderList[0];
                    this.folderList[0] = this.folderList[i];
                    this.folderList[i] = this.folder;
                    this.listModel.insertElementAt((Object)(this.folderList[0].getName() + " : " + this.folderList[0].getUnreadMessageCount() + "/" + this.folderList[0].getMessageCount()), 0);
                    continue;
                }
                for (int j = i; j < this.folderList.length - 1; ++j) {
                    if ((this.folderList[j].getType() & 1) != 0) continue;
                    this.folder = this.folderList[j];
                    this.folderList[j] = this.folderList[j + 1];
                    this.folderList[j + 1] = this.folder;
                }
            }
            for (i = 1; i < this.folderList.length; ++i) {
                if ((this.folderList[i].getType() & 1) != 0) {
                    if (this.mailDebug) {
                        System.out.println(i + " name = " + this.folderList[i].getName());
                    }
                    this.listModel.addElement((Object)(this.folderList[i].getName() + " : " + this.folderList[i].getUnreadMessageCount() + "/" + this.folderList[i].getMessageCount()));
                    continue;
                }
                if (!this.mailDebug) continue;
                System.out.println(i + " Hold NO Messg : name = " + this.folderList[i].getName() + ", type = " + this.folderList[i].getType());
            }
        }
        catch (Exception e) {
            System.out.println(" new MailUserData  " + this.url + " " + e.toString());
            this.configOK = false;
            this.displayErrorForm("Read Folder", this.url + " : " + e.getMessage());
            this.url = null;
            this.session = null;
            this.store = null;
            return;
        }
        if (this.mailDebug) {
            System.out.println("<== displayAllFolder");
        }
    }

    private class CommandDispatcher
    implements PActionListener {
        public void actionEvent(PActionEvent pactionevent) {
            if (IMapClientForm.this.mailDebug) {
                System.out.println("==> CommandDispatcher.actionEvent " + pactionevent.getActionCommand());
            }
            if (pactionevent.getActionCommand().equals("readMail") || pactionevent.getActionCommand().equals("back")) {
                IMapClientForm.this.setTitle("IMAP Mail V 1.1");
                IMapClientForm.this.folderListLayout();
                IMapClientForm.this.displayAllFolder();
                if (IMapClientForm.this.listModel.getSize() > 0) {
                    IMapClientForm.this.mailList.setSelectedIndex(0);
                }
                IMapClientForm.this.folderMenubar();
            } else if (pactionevent.getActionCommand().equals("main")) {
                IMapClientForm.this.configWindow();
                IMapClientForm.this.initMenubar();
            } else if (pactionevent.getActionCommand().equals("exit")) {
                IMapClientForm.this.onCancel();
            } else if (pactionevent.getActionCommand().equals("config")) {
                IMapClientForm.this.config();
            } else if (pactionevent.getActionCommand().equals(PList.ACTION_DOUBLE_CLICK)) {
                IMapClientForm.this.readFolderEntrys();
            }
        }

        CommandDispatcher() {
        }
    }

    private class emailCommandDispatcher
    implements PActionListener {
        private PAbstractForm formToClose = null;

        private emailCommandDispatcher() {
        }

        public void actionEvent(PActionEvent pactionevent) {
            if (IMapClientForm.this.mailDebug) {
                System.out.println("==>emailCommandDispatcher..actionEvent " + pactionevent.getActionCommand());
            }
            if (pactionevent.getActionCommand().equals("menu")) {
                this.formToClose.closeForm(3);
            } else if (!pactionevent.getActionCommand().equals("next") && pactionevent.getActionCommand().equals("close")) {
                this.formToClose.closeForm(3);
            }
        }

        public void setPAbstractForm(PAbstractForm formToClose) {
            this.formToClose = formToClose;
        }
    }

    private class folderCommandDispatcher
    implements PActionListener {
        private folderCommandDispatcher() {
        }

        public void actionEvent(PActionEvent pactionevent) {
            if (IMapClientForm.this.mailDebug) {
                System.out.println("==>folderCommandDispatcher.actionEvent " + pactionevent.getActionCommand());
            }
            if (pactionevent.getActionCommand().equals(PList.ACTION_DOUBLE_CLICK)) {
                IMapClientForm.this.readMailEntrys();
            }
        }
    }
}

